<?php
/**
 * Uninstall-Routine: Loescht alle Plugin-Daten aus der Datenbank
 *
 * @package WP_Grid_Connector
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

global $wpdb;

// Optionen loeschen
delete_option( 'wpgrid_api_key' );
delete_option( 'wpgrid_version' );
delete_option( 'wpgrid_ip_whitelist' );
delete_option( 'wpgrid_ip_whitelist_raw' );
delete_option( 'wpgrid_snippets' );

// Log-Tabelle loeschen
$wpgrid_tabelle = $wpdb->prefix . 'wpgrid_logs';
// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,PluginCheck.Security.DirectDB.UnescapedDBParameter -- Uninstall routine
$wpdb->query( "DROP TABLE IF EXISTS {$wpgrid_tabelle}" );

// Rate-Limit Transients loeschen
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Uninstall cleanup
$wpdb->query(
    "DELETE FROM {$wpdb->options}
     WHERE option_name LIKE '_transient_wpgrid_rl_%'
        OR option_name LIKE '_transient_timeout_wpgrid_rl_%'"
);
